<h1 align="center">
  <img src="./README_assets/img/mascot.jpg" alt="Karing" width="256" />
  <br>
  Karing - Простая и мощная прокси-утилита
  <br>
</h1>

<h3 align="center">
GUI для <a href="https://github.com/SagerNet/sing-box">singbox</a> на базе <a href="https://github.com/flutter/flutter">flutter</a>.
</h3>

[English](./README.md) | [简体中文](./README_cn.md) | [繁體中文](./README_tw.md) | [日本語](./README_ja.md) | [한국어](./README_ko.md) | [Español](./README_es.md) | [Français](./README_fr.md) | [Deutsch](./README_de.md) | [Italiano](./README_it.md) | [Tiếng Việt](./README_vi.md) | [Türkçe](./README_tr.md) | Русский | [فارسی](./README_fa.md) | [العربية](./README_ar.md) | [Português](./README_pt.md) | [Українська](./README_uk.md) | [Polski](./README_pl.md) | [اردو](./README_ur.md) | [Svenska](./README_sv.md) | [Norsk](./README_no.md) | [Nederlands](./README_nl.md) | [हिन्दी](./README_hi.md) | [Ελληνικά](./README_el.md) | [Dansk](./README_da.md) | [বাংলা](./README_bn.md)

### Примечание: У Karing нет официальных каналов на видеоплатформах.

## Особенности
- Совместимость с подписками Clash, V2ray/V2fly, Sing-box, Shadowsocks, Sub, Github.
  - Полная поддержка конфигурации `clash`, частичная поддержка конфигурации `clash.meta`.

- Набор правил маршрутизации, применяемых к нескольким источникам подписки, автоматически выбирает эффективные узлы.
- Поддержка настраиваемых групп правил маршрутизации и групп узлов.
  - Настройка групп правил маршрутизации по умолчанию для начинающих пользователей - готово к использованию сразу после установки.
  - Встроенные geo-IP, geo-site, ACL и [другие наборы правил](https://github.com/KaringX/karing-ruleset/).

- Резервное копирование и синхронизация, синхронизация нескольких устройств с одной конфигурацией.
  - Поддержка синхронизации iCloud [IOS/MacOS].
  - Поддержка синхронизации в локальной сети.
  - Поддержка WebDAV.
  - Поддержка импорта/экспорта ZIP-файлов.

- Встроенная поддержка [модифицированного ядра sing-box](https://github.com/KaringX/sing-box).
- Наличие режима для новичков для более простой настройки.
- Планы по поддержке большего количества платформ.

## Реклама
<details>
<summary>Посмотреть все акции

### Рекомендуемый VPN

[Doggygo VPN —— Ускорение для экспертов](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053)

- Высокопроизводительный зарубежный провайдер VPN/Proxy, международная команда, отсутствие риска закрытия.
- Регистрация по эксклюзивной ссылке дает 3 дня и 1 ГБ ежедневного трафика [Бесплатная пробная версия](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053).
- Пакеты со скидкой всего от 15,8 юаней в месяц, 160 ГБ трафика, скидка 20% при годовой оплате.
- Первый в мире с поддержкой протокола `Hysteria2`, конструкция балансировки нагрузки кластера, высокоскоростная выделенная линия, чрезвычайно низкая задержка, игнорирует ночные пики, мгновенное 4K.
- Разблокирует потоковые мультимедиа и ChatGPT.

[👉 Больше предложений, обновляемых ежедневно](https://1.x31415926.top/)

</summary>

### 🤝 Объявление о сотрудничестве для VPN-провайдеров
- 👉 [Контактная информация и формы сотрудничества](https://karing.app/blog/isp/cooperation#for-vpn-providers-from-other-regions) 👈
</details>

## Системные требования
- Windows >= 10 (только 64-бит)
- Android >= 8 (arm64-v8a, armeabi-v7a)
- Linux (только 64-бит)
- IOS >= 15
- MacOS >= 12 (Intel, Apple Silicon)
- TvOS >= 17

## Установка
- **IOS/TvOS AppStore**: (Ключевые слова для поиска: karing vpn)
  - https://apps.apple.com/us/app/karing/id6472431552
- **IOS/TvOS TestFlight**:
  - https://testflight.apple.com/join/RLU59OsJ
- **Android**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest
  - APKPure https://apkpure.com/p/com.nebula.karing
  - Amazon AppStore https://www.amazon.com/gp/product/B0DJSQDDM8
- **Windows/Macos/Linux**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest

### FAQ (Часто задаваемые вопросы)

> [FAQ|ru](https://karing.app/en/faq/)

## Планы (Todos)
- Платформы, которые будут поддерживаться:
  - linux | [linglong](https://linglong.dev/)
- Глобализация (многоязычность)
  - Если вы готовы работать с нами над поддержкой глобализации Karing, пожалуйста, свяжитесь с нами через [Telegram](https://t.me/ovowe).

## Скриншоты

<div align="center">
  <img src="./README_assets/demo/home.png" alt="demo1" width="50%" />
  </br></br>
  <img src="./README_assets/demo/select_server.png" alt="demo2" width="50%" />
    </br></br>
  <img src="./README_assets/demo/connections.png" alt="demo3" width="50%" />
  </br></br>
  <img src="./README_assets/demo/setting.png" alt="demo4" width="50%" />
  </br></br>
  <img src="./README_assets/demo/routing_group.png" alt="demo5" width="50%" />
  </br></br>
  <img src="./README_assets/demo/add_profile_link.png" alt="demo6" width="50%" />
</div>

## Вклад
[Мы приветствуем сообщения об ошибках!](https://github.com/KaringX/karing/issues)

## Пожертвовать
![donate](./README_assets/img/donate-usdt.jpg)

## Проекты
### Благодарности: Karing основан на этих проектах или вдохновлен ими:

- [flutter](https://flutter.dev/): позволяет легко и быстро создавать красивые приложения для мобильных устройств и не только.
- [singbox](https://sing-box.sagernet.org/): универсальная прокси-платформа.
- [Meta-Docs](https://wiki.metacubex.one/config/): документация Clash.Meta

### Команда Karing:
- [Karing](https://karing.app): https://karing.app
- [Clash Mi](https://clashmi.app/): https://clashmi.app/
- [sing-poet](https://github.com/KaringX/sing-poet)

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=KaringX/karing&type=Date)](https://star-history.com/#KaringX/karing&Date)
