<h1 align="center">
  <img src="./README_assets/img/mascot.jpg" alt="Karing" width="256" />
  <br>
  Karing - Utilitário de proxy simples e poderoso
  <br>
</h1>

<h3 align="center">
Uma GUI para <a href="https://github.com/SagerNet/sing-box">singbox</a> baseada em <a href="https://github.com/flutter/flutter">flutter</a>.
</h3>

[English](./README.md) | [简体中文](./README_cn.md) | [繁體中文](./README_tw.md) | [日本語](./README_ja.md) | [한국어](./README_ko.md) | [Español](./README_es.md) | [Français](./README_fr.md) | [Deutsch](./README_de.md) | [Italiano](./README_it.md) | [Tiếng Việt](./README_vi.md) | [Türkçe](./README_tr.md) | [Русский](./README_ru.md) | [فارسی](./README_fa.md) | [العربية](./README_ar.md) | Português | [Українська](./README_uk.md) | [Polski](./README_pl.md) | [اردو](./README_ur.md) | [Svenska](./README_sv.md) | [Norsk](./README_no.md) | [Nederlands](./README_nl.md) | [हिन्दी](./README_hi.md) | [Ελληνικά](./README_el.md) | [Dansk](./README_da.md) | [বাংলা](./README_bn.md)

### Nota: O Karing não abriu nenhum canal relacionado ao Karing em nenhuma plataforma de vídeo.

## Características
- Compatível com subscrições Clash, V2ray/V2fly, Sing-box, Shadowsocks, Sub, Github.
  - Suporte completo para configuração `clash`, suporte parcial para configuração `clash.meta`.

- Um conjunto de regras de roteamento aplicado a múltiplas fontes de subscrição seleciona automaticamente os nós mais eficientes.
- Suporta grupos de regras de roteamento personalizados e grupos de nós.
  - Personaliza grupos de regras de roteamento padrão para utilizadores iniciantes - pronto a usar.
  - Inclui geo-IP, geo-site, ACL e [outros conjuntos de regras](https://github.com/KaringX/karing-ruleset/) integrados.

- Cópia de segurança e sincronização, sincronizando múltiplos dispositivos com uma única configuração.
  - Suporta sincronização iCloud [IOS/MacOS].
  - Suporta sincronização dentro da rede local.
  - Suporta WebDAV.
  - Suporta importação/exportação de ficheiros ZIP.

- Suporte integrado para o [núcleo sing-box modificado](https://github.com/KaringX/sing-box).
- Introduz um modo de iniciante para uma configuração mais simples.
- Plano para suportar mais plataformas.

## Promoção
<details>
<summary>Ver todas as promoções

### VPN Recomendada

[Doggygo VPN —— Aceleração para especialistas](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053)

- Provedor (Airport) de alto desempenho no exterior, equipa internacional, sem risco de encerramento.
- O registo através de link exclusivo oferece 3 dias e 1 GB de tráfego diário [Teste gratuito](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053).
- Pacotes de desconto a partir de apenas 15,8 yuans por mês, 160 GB de tráfego, 20% de desconto no pagamento anual.
- O primeiro no mundo a suportar o protocolo `Hysteria2`, design de equilíbrio de carga em cluster, linha dedicada de alta velocidade, latência extremamente baixa, ignora picos noturnos, 4K instantâneo.
- Desbloqueia media em streaming e ChatGPT.

[👉 Mais ofertas atualizadas diariamente](https://1.x31415926.top/)

</summary>

### 🤝 Anúncio de colaboração para provedores de VPN
- 👉 [Informações de contacto e formas de cooperação](https://karing.app/blog/isp/cooperation#for-vpn-providers-from-other-regions) 👈
</details>

## Requisitos do Sistema
- Windows >= 10 (apenas 64 bits)
- Android >= 8 (arm64-v8a, armeabi-v7a)
- Linux (apenas 64 bits)
- IOS >= 15
- MacOS >= 12 (Intel, Apple Silicon)
- TvOS >= 17

## Instalação
- **IOS/TvOS AppStore**: (Palavras-chave de pesquisa: karing vpn)
  - https://apps.apple.com/us/app/karing/id6472431552
- **IOS/TvOS TestFlight**:
  - https://testflight.apple.com/join/RLU59OsJ
- **Android**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest
  - APKPure https://apkpure.com/p/com.nebula.karing
  - Amazon AppStore https://www.amazon.com/gp/product/B0DJSQDDM8
- **Windows/Macos/Linux**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest

### FAQ (Perguntas Frequentes)

> [FAQ|pt](https://karing.app/en/faq/)

## Tarefas (Todos)
- Plataformas a serem suportadas:
  - linux | [linglong](https://linglong.dev/)
- Globalização (multi-idioma)
  - Se estiver disposto a trabalhar connosco para apoiar a globalização do Karing, por favor contacte-nos via [Telegram](https://t.me/ovowe).

## Capturas de Ecrã

<div align="center">
  <img src="./README_assets/demo/home.png" alt="demo1" width="50%" />
  </br></br>
  <img src="./README_assets/demo/select_server.png" alt="demo2" width="50%" />
    </br></br>
  <img src="./README_assets/demo/connections.png" alt="demo3" width="50%" />
  </br></br>
  <img src="./README_assets/demo/setting.png" alt="demo4" width="50%" />
  </br></br>
  <img src="./README_assets/demo/routing_group.png" alt="demo5" width="50%" />
  </br></br>
  <img src="./README_assets/demo/add_profile_link.png" alt="demo6" width="50%" />
</div>

## Contribuições
[Bem-vindo a reportar erros!](https://github.com/KaringX/karing/issues)

## Doações
![donate](./README_assets/img/donate-usdt.jpg)

## Projetos
### Agradecimentos: O Karing foi baseado ou inspirado nestes projetos:

- [flutter](https://flutter.dev/): torna fácil e rápido construir aplicações bonitas para telemóveis e não só.
- [singbox](https://sing-box.sagernet.org/): A plataforma de proxy universal.
- [Meta-Docs](https://wiki.metacubex.one/config/): Documentação do Clash.Meta

### Equipa Karing:
- [Karing](https://karing.app): https://karing.app
- [Clash Mi](https://clashmi.app/): https://clashmi.app/
- [sing-poet](https://github.com/KaringX/sing-poet)

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=KaringX/karing&type=Date)](https://star-history.com/#KaringX/karing&Date)
