<h1 align="center">
  <img src="./README_assets/img/mascot.jpg" alt="Karing" width="256" />
  <br>
  Karing - Eenvoudig en krachtig proxy-hulpprogramma
  <br>
</h1>

<h3 align="center">
Een <a href="https://github.com/SagerNet/sing-box">singbox</a> GUI gebaseerd op <a href="https://github.com/flutter/flutter">flutter</a>.
</h3>

[English](./README.md) | [简体中文](./README_cn.md) | [繁體中文](./README_tw.md) | [日本語](./README_ja.md) | [한국어](./README_ko.md) | [Español](./README_es.md) | [Français](./README_fr.md) | [Deutsch](./README_de.md) | [Italiano](./README_it.md) | [Tiếng Việt](./README_vi.md) | [Türkçe](./README_tr.md) | [Русский](./README_ru.md) | [فارسی](./README_fa.md) | [العربية](./README_ar.md) | [Português](./README_pt.md) | [Українська](./README_uk.md) | [Polski](./README_pl.md) | [اردو](./README_ur.md) | [Svenska](./README_sv.md) | [Norsk](./README_no.md) | Nederlands | [हिन्दी](./README_hi.md) | [Ελληνικά](./README_el.md) | [Dansk](./README_da.md) | [বাংলা](./README_bn.md)

### Opmerking: Karing heeft op geen enkel videoplatform een kanaal geopend dat gerelateerd is aan Karing.

## Kenmerken
- Compatibel met Clash, V2ray/V2fly, Sing-box, Shadowsocks, Sub, Github-abonnementen.
  - Volledige ondersteuning voor `clash`-configuratie, gedeeltelijke ondersteuning voor `clash.meta`-configuratie.

- Een set routeringsregels toegepast op meerdere abonnementsbronnen selecteert automatisch efficiënte nodes.
- Ondersteunt aangepaste routeringsregelgroepen en nodegroepen.
  - Past standaard routeringsregelgroepen aan voor beginnende gebruikers - direct klaar voor gebruik.
  - Ingebouwde geo-IP, geo-site, ACL en [andere regelsets](https://github.com/KaringX/karing-ruleset/).

- Back-up en synchronisatie, synchroniseer meerdere apparaten met een enkele configuratie.
  - Ondersteunt iCloud-synchronisatie [IOS/MacOS].
  - Ondersteunt synchronisatie binnen het lokale netwerk.
  - Ondersteunt WebDAV.
  - Ondersteunt het importeren/exporteren van ZIP-bestanden.

- Ingebouwde ondersteuning voor de [aangepaste sing-box core](https://github.com/KaringX/sing-box).
- Introduceert een beginnersmodus voor eenvoudigere configuratie.
- Plan om meer platforms te ondersteunen.

## Promotie
<details>
<summary>Bekijk alle promoties

### Aanbevolen VPN

[Doggygo VPN —— Versnelling voor experts](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053)

- Krachtige overzeese provider (Airport), internationaal team, geen risico op sluiting.
- Registratie via exclusieve link geeft 3 dagen en 1G dagelijks verkeer [Gratis proefperiode](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053).
- Kortingspakketten vanaf slechts 15,8 yuan per maand, 160G verkeer, 20% korting bij jaarbetaling.
- De eerste ter wereld die het `Hysteria2`-protocol ondersteunt, cluster load balancing-ontwerp, snelle dedicated lijn, extreem lage latentie, negeert nachtelijke pieken, 4K direct klaar.
- Ontgrendelt streaming media en ChatGPT.

[👉 Meer aanbiedingen, dagelijks bijgewerkt](https://1.x31415926.top/)

</summary>

### 🤝 Samenwerkingsaankondiging voor VPN-providers
- 👉 [Contactgegevens en samenwerkingsvormen](https://karing.app/blog/isp/cooperation#for-vpn-providers-from-other-regions) 👈
</details>

## Systeemvereisten
- Windows >= 10 (alleen 64-bit)
- Android >= 8 (arm64-v8a, armeabi-v7a)
- Linux (alleen 64-bit)
- IOS >= 15
- MacOS >= 12 (Intel, Apple Silicon)
- TvOS >= 17

## Installatie
- **IOS/TvOS AppStore**: (Zoekwoorden: karing vpn)
  - https://apps.apple.com/us/app/karing/id6472431552
- **IOS/TvOS TestFlight**:
  - https://testflight.apple.com/join/RLU59OsJ
- **Android**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest
  - APKPure https://apkpure.com/p/com.nebula.karing
  - Amazon AppStore https://www.amazon.com/gp/product/B0DJSQDDM8
- **Windows/Macos/Linux**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest

### FAQ (Veelgestelde vragen)

> [FAQ|nl](https://karing.app/en/faq/)

## Te doen (Todos)
- Platforms die ondersteund zullen worden:
  - linux | [linglong](https://linglong.dev/)
- Globalisering (meertaligheid)
  - Als u bereid bent met ons samen te werken om de globalisering van Karing te ondersteunen, neem dan contact met ons op via [Telegram](https://t.me/ovowe).

## Screenshots

<div align="center">
  <img src="./README_assets/demo/home.png" alt="demo1" width="50%" />
  </br></br>
  <img src="./README_assets/demo/select_server.png" alt="demo2" width="50%" />
    </br></br>
  <img src="./README_assets/demo/connections.png" alt="demo3" width="50%" />
  </br></br>
  <img src="./README_assets/demo/setting.png" alt="demo4" width="50%" />
  </br></br>
  <img src="./README_assets/demo/routing_group.png" alt="demo5" width="50%" />
  </br></br>
  <img src="./README_assets/demo/add_profile_link.png" alt="demo6" width="50%" />
</div>

## Bijdragen
[Welkom om problemen te melden!](https://github.com/KaringX/karing/issues)

## Doneren
![donate](./README_assets/img/donate-usdt.jpg)

## Projecten
### Dankbetuiging: Karing is gebaseerd op of geïnspireerd door deze projecten:

- [flutter](https://flutter.dev/): maakt het gemakkelijk en snel om prachtige apps te bouwen voor mobiel en daarbuiten.
- [singbox](https://sing-box.sagernet.org/): Het universele proxyplatform.
- [Meta-Docs](https://wiki.metacubex.one/config/): Clash.Meta-documentatie

### Karing-team:
- [Karing](https://karing.app): https://karing.app
- [Clash Mi](https://clashmi.app/): https://clashmi.app/
- [sing-poet](https://github.com/KaringX/sing-poet)

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=KaringX/karing&type=Date)](https://star-history.com/#KaringX/karing&Date)
