<h1 align="center">
  <img src="./README_assets/img/mascot.jpg" alt="Karing" width="256" />
  <br>
  Karing - Einfaches und leistungsstarkes Proxy-Dienstprogramm
  <br>
</h1>

<h3 align="center">
Eine <a href="https://github.com/flutter/flutter">flutter</a>-basierte GUI für <a href="https://github.com/SagerNet/sing-box">singbox</a>.
</h3>

[English](./README.md) | [简体中文](./README_cn.md) | [繁體中文](./README_tw.md) | [日本語](./README_ja.md) | [한국어](./README_ko.md) | [Español](./README_es.md) | [Français](./README_fr.md) | Deutsch | [Italiano](./README_it.md) | [Tiếng Việt](./README_vi.md) | [Türkçe](./README_tr.md) | [Русский](./README_ru.md) | [فارسی](./README_fa.md) | [العربية](./README_ar.md) | [Português](./README_pt.md) | [Українська](./README_uk.md) | [Polski](./README_pl.md) | [اردو](./README_ur.md) | [Svenska](./README_sv.md) | [Norsk](./README_no.md) | [Nederlands](./README_nl.md) | [हिन्दी](./README_hi.md) | [Ελληνικά](./README_el.md) | [Dansk](./README_da.md) | [বাংলা](./README_bn.md)

### Hinweis: Karing hat auf keiner Videoplattform einen Kanal im Zusammenhang mit Karing eröffnet.

## Funktionen
- Kompatibel mit Clash, V2ray/V2fly, Sing-box, Shadowsocks, Sub, Github-Abonnements.
  - Vollständige Unterstützung der `clash`-Konfiguration, teilweise Unterstützung der `clash.meta`-Konfiguration.

- Ein Satz von Routing-Regeln, der auf mehrere Abonnements angewendet wird, wählt automatisch effiziente Knoten aus.
- Unterstützt benutzerdefinierte Routing-Regelgruppen und Knotengruppen.
  - Passt Standard-Routing-Regelgruppen für Anfänger an - sofort einsatzbereit.
  - Integriertes Geo-IP, Geo-Site, ACL und [andere Regelsätze](https://github.com/KaringX/karing-ruleset/).

- Sicherung und Synchronisierung, Synchronisierung mehrerer Geräte mit einer einzigen Konfiguration.
  - Unterstützt iCloud-Synchronisierung [IOS/MacOS].
  - Unterstützt die Synchronisierung innerhalb des lokalen Netzwerks.
  - Unterstützt WebDAV.
  - Unterstützt das Importieren/Exportieren von ZIP-Dateien.

- Integrierte Unterstützung für den [modifizierten sing-box-Kern](https://github.com/KaringX/sing-box).
- Einführung eines Anfängermodus für eine einfachere Konfiguration.
- Planung der Unterstützung weiterer Plattformen.

## Werbung
<details>
<summary>Alle Werbeaktionen anzeigen

### Empfohlener VPN-Anbieter

[Doggygo VPN —— Hochleistungs-VPN](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053)

- Leistungsstarker Übersee-Anbieter, internationales Team, kein Risiko einer Schließung.
- Registrierung über exklusiven Link gibt 3 Tage und 1G tägliches Datenvolumen [Kostenlose Testversion](https://1.x31415926.top/redir.html?url=aHR0cHM6Ly93d3cuZGc2LnRvcC8jL3JlZ2lzdGVyP2NvZGU9bEZINGlpOUQ=&i=3eb&t=1723644053).
- Pakete ab nur 15,8 Yuan pro Monat, 160G Datenvolumen, 20% Rabatt bei jährlicher Zahlung.
- Weltweit erster Anbieter mit Unterstützung für das `Hysteria2`-Protokoll, Cluster-Lastverteilungsdesign, Hochgeschwindigkeits-Dedizierte Leitung, extrem niedrige Latenz, ignoriert Spitzenzeiten, 4K sofort bereit.
- Entsperrt Streaming-Medien und ChatGPT.

[👉 Mehr Angebote, täglich aktualisiert](https://1.x31415926.top/)

</summary>

### 🤝 Kooperationsankündigung für VPN-Anbieter
- 👉 [Kontaktinformationen und Kooperationsformen](https://karing.app/blog/isp/cooperation#for-vpn-providers-from-other-regions) 👈
</details>

## Systemanforderungen
- Windows >= 10 (nur 64-Bit)
- Android >= 8 (arm64-v8a, armeabi-v7a)
- Linux (nur 64-Bit)
- IOS >= 15
- MacOS >= 12 (Intel, Apple Silicon)
- TvOS >= 17

## Installation
- **IOS/TvOS AppStore**: (Suchbegriffe: karing vpn)
  - https://apps.apple.com/us/app/karing/id6472431552
- **IOS/TvOS TestFlight**:
  - https://testflight.apple.com/join/RLU59OsJ
- **Android**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest
  - APKPure https://apkpure.com/p/com.nebula.karing
  - Amazon AppStore https://www.amazon.com/gp/product/B0DJSQDDM8
- **Windows/Macos/Linux**:
  - [https://karing.app/download](https://karing.app/download)
  - https://github.com/KaringX/karing/releases/latest

### FAQ

> [FAQ|de](https://karing.app/en/faq/)

## Aufgaben (Todos)
- Zu unterstützende Plattformen:
  - linux | [linglong](https://linglong.dev/)
- Globalisierung (Mehrsprachigkeit)
  - Wenn Sie bereit sind, mit uns an der Globalisierung von Karing zu arbeiten, kontaktieren Sie uns bitte über [Telegram](https://t.me/ovowe).

## Screenshots

<div align="center">
  <img src="./README_assets/demo/home.png" alt="demo1" width="50%" />
  </br></br>
  <img src="./README_assets/demo/select_server.png" alt="demo2" width="50%" />
    </br></br>
  <img src="./README_assets/demo/connections.png" alt="demo3" width="50%" />
  </br></br>
  <img src="./README_assets/demo/setting.png" alt="demo4" width="50%" />
  </br></br>
  <img src="./README_assets/demo/routing_group.png" alt="demo5" width="50%" />
  </br></br>
  <img src="./README_assets/demo/add_profile_link.png" alt="demo6" width="50%" />
</div>

## Beiträge
[Willkommen, Fehler zu melden!](https://github.com/KaringX/karing/issues)

## Spenden
![donate](./README_assets/img/donate-usdt.jpg)

## Projekte
### Danksagung: Karing basierte auf oder wurde inspiriert durch diese Projekte und so weiter:

- [flutter](https://flutter.dev/): macht es einfach und schnell, schöne Apps für Mobilgeräte und darüber hinaus zu entwickeln.
- [singbox](https://sing-box.sagernet.org/): Die universelle Proxy-Plattform.
- [Meta-Docs](https://wiki.metacubex.one/config/): Clash.Meta-Dokumentation

### Karing-Team:
- [Karing](https://karing.app): https://karing.app
- [Clash Mi](https://clashmi.app/): https://clashmi.app/
- [sing-poet](https://github.com/KaringX/sing-poet)

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=KaringX/karing&type=Date)](https://star-history.com/#KaringX/karing&Date)
