# CONTRIBUTING

Thank you for your interest in contributing to Clash Verge Rev! This document provides guidelines and instructions to help you set up your development environment and start contributing.

## Internationalization (i18n)

We welcome translations and improvements to existing locales. Please follow the detailed guidelines in [CONTRIBUTING_i18n.md](docs/CONTRIBUTING_i18n.md) for instructions on extracting strings, file naming conventions, testing translations, and submitting translation PRs.

## Development Setup

Before you start contributing to the project, you need to set up your development environment. Here are the steps you need to follow:

### Prerequisites

1. **Install Rust and Node.js**: Our project requires both Rust and Node.js. Please follow the instructions provided [here](https://tauri.app/start/prerequisites/) to install them on your system.

### Setup for Windows Users

> [!NOTE]
> **If you are using a Windows ARM device, you additionally need to install [LLVM](https://github.com/llvm/llvm-project/releases) (including clang) and set the environment variable.**
>
> Because the `ring` crate is compiled based on `clang` under Windows ARM.

If you're a Windows user, you may need to perform some additional steps:

- Make sure to add Rust and Node.js to your system's PATH. This is usually done during the installation process, but you can verify and manually add them if necessary.
- The gnu `patch` tool should be installed

When you setup `Rust` environment, Only use toolchain with `Windows MSVC` , to change settings follow command:

```shell
rustup target add x86_64-pc-windows-msvc
rustup set default-host x86_64-pc-windows-msvc
```

### Install Node.js Package

After installing Rust and Node.js, install the necessary Node.js and Node Package Manager:

```shell
npm install pnpm -g
```

### Install Dependencies

Install node packages

```shell
pnpm install
```

Install apt packages ONLY for Ubuntu

```shell
apt-get install -y libxslt1.1 libwebkit2gtk-4.1-dev libayatana-appindicator3-dev librsvg2-dev patchelf
```

### Download the Mihomo Core Binary

You have two options for downloading the clash binary:

- Automatically download it via the provided script:

  ```shell
  pnpm run prebuild
  # Use '--force' or '-f' to update both the Mihomo core version
  # and the Clash Verge Rev service version to the latest available.
  pnpm run prebuild --force
  ```

- Manually download it from the [Mihomo release](https://github.com/MetaCubeX/mihomo/releases). After downloading, rename the binary according to the [Tauri configuration](https://tauri.app/v1/api/config#bundleconfig.externalbin).

### Run the Development Server

To run the development server, use the following command:

```shell
pnpm dev
# If an app instance already exists, use a different command
pnpm dev:diff
# To using tauri built-in dev tool
pnpm dev:tauri
```

### Build the Project

To build this project:

```shell
pnpm build
```

For a faster build, use the following command

```shell
pnpm build:fast
```

This uses Rust's fast-release profile which significantly reduces compilation time by disabling optimization and LTO. The resulting binary will be larger and less performant than the standard build, but it's useful for testing changes quickly.

The `Artifacts` will display in the `log` in the Terminal.

### Build clean

To clean rust build:

```shell
pnpm clean
```

### Portable Version (Windows Only)

To package portable version after the build:

```shell
pnpm portable
```

## Contributing Your Changes

#### Before commit your changes

If you changed the rust code, it's recommanded to execute code style formatting and quailty checks.

1. Code quailty checks

```bash
# For rust backend
$ clash-verge-rev: pnpm clippy
# For frontend (not yet).
```

2. Code style formatting

```bash
# For rust backend
$ clash-verge-rev: cd src-tauri
$ clash-verge-rev/src-tauri: cargo fmt
# For frontend
$ clash-verge-rev: pnpm format:check
$ clash-verge-rev: pnpm format
```

Once you have made your changes:

1. Fork the repository.
2. Create a new branch for your feature or bug fix.
3. Commit your changes with clear and concise commit messages.
4. Push your branch to your fork and submit a pull request to our repository.

We appreciate your contributions and look forward to your active participation in our project!
